//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.0

import wesual.Controls 1.0

PopupAnchorItem {
    id : anchorItem

    property Item comboBox
    property list<ComboBoxItem> items
    property int activeIndex : -1
    property int currentSelection : -1

    signal accepted(int result)

    enabled : visible

    popup : Item {

        width :  itemColumn.width + 2 * bg.border.width
        height : itemColumn.height + 2 * bg.border.width

        Rectangle {
            id : bg

            anchors.fill : parent
            border {
                color : UI.color(UI.PrimaryControlBorder)
                width : 1
            }
        }

        visible : anchorItem.popupVisible

        // Key handling
        Keys.onUpPressed : {
            if (items.length < 1)
                return;

            var index = anchorItem.activeIndex - 1;
            if (index < 0)
                index = items.length - 1;
            anchorItem.activeIndex = index;
        }
        Keys.onDownPressed : {
            if (items.length < 1)
                return;

            anchorItem.activeIndex = (anchorItem.activeIndex + 1) % items.length;
        }
        Keys.onEscapePressed : anchorItem.hide()
        Keys.onReturnPressed : {
            anchorItem.accepted(anchorItem.activeIndex >= 0 ?
                                anchorItem.activeIndex : undefined);
        }

        Column {
            id : itemColumn

            readonly property int margin : 8

            readonly property int idealWidth : {
                var max = anchorItem.comboBox ?
                          (anchorItem.comboBox.width - bg.border.width * 2) : 0;
                for (var i = 0; i < children.length; ++i) {
                    max = Math.max(max, children[i].implicitWidth);
                }

                return max;
            }

            x : bg.border.width
            y : bg.border.width
            width : idealWidth
            height : childrenRect.height

            // 3px space before first element
            Item {
                width   : itemColumn.idealWidth
                height  : 3
            }

            Repeater {
                model : anchorItem.items
                delegate : Item {

                    readonly property int  itemIndex : index
                    readonly property bool active :
                                                anchorItem.activeIndex === index

                    implicitWidth : label.implicitWidth + 2 * itemColumn.margin
                    width : itemColumn.idealWidth
                    height : 26

                    Rectangle {
                        id : itemBackground

                        height : parent.height
                        width : itemColumn.idealWidth
                        color : UI.color(UI.PrimaryBase)

                        Behavior on color {
                            ColorAnimation {
                                duration : 0
                            }
                        }

                        states : [
                            State {
                                name : "selected"
                                when : anchorItem.currentSelection === index ||
                                       (active && mouseArea.pressed)

                                PropertyChanges {
                                    target : itemBackground
                                    color : UI.color(UI.PrimaryPress)
                                }
                            },
                            State {
                                name : "hovered"
                                when : active

                                PropertyChanges {
                                    target : itemBackground
                                    color  : UI.color(UI.PrimaryHover)
                                }
                            }
                        ]
                    }

                    Text {
                        id : label
                        text : modelData.text
                        x : itemColumn.margin
                        y : 19 - font.pixelSize
                        anchors.verticalCenter : parent.verticalCenter
                        font {
                            family : UI.fontFamily(UI.PrimaryFont)
                            weight : UI.fontWeight(UI.PrimaryFont)
                            pixelSize : 14
                        }
                        color : {
                            if (itemBackground.state === "selected")
                                return UI.color(UI.SelectedTextColor);
                            else
                                return UI.color(UI.PrimaryTextColor);
                        }
                    }
                }
            }

            // 3px space after last element
            Item {
                width   : itemColumn.idealWidth
                height  : 3
            }
        }

        MouseArea {
            id : mouseArea
            anchors.fill : parent
            acceptedButtons : Qt.LeftButton
            hoverEnabled : true
            onPositionChanged : {
                var child = itemColumn.childAt(mouse.x, mouse.y);
                if (child && child.itemIndex !== undefined) {
                    anchorItem.activeIndex = child.itemIndex;
                }
            }
            onReleased : anchorItem.accepted(anchorItem.activeIndex)
        }
    }
}
